<?php

namespace App\Http\Controllers;

use App\Models\SalasInversion; 
use App\Models\Promociones; 
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse; 
use Illuminate\Support\Facades\Storage;
use App\Http\Controllers\View; 
use Carbon\Carbon;
use Mail;
use DB;
use Auth;

class SalasInversionController extends Controller
{
    /**
     * Display a listing of the resource.
     */

    public function Listsalasinversion()
    { 
        $salas_inversion = SalasInversion::orderBy('valor', 'asc')->get();

        return view('salas_inversion.catalogo',compact('salas_inversion'));
        
    }

    public function Addsalasinversion()
    {
        
        return view('salas_inversion.registro');
        
    }

    public function Savesalasinversion(Request $request)
    { 
        
        $salas_inversion = new SalasInversion();
        $salas_inversion->nombre=$request->input('nombre');        
        $salas_inversion->descripcion=$request->input('descripcion');    
        $salas_inversion->valor=$request->input('valor');  
        $salas_inversion->porcentaje_invitacion_directa=$request->input('porcentaje_invitacion_directa');  
        $salas_inversion->porcentaje_interes_compuesto=$request->input('porcentaje_interes_compuesto');  
        $salas_inversion->porcentaje_sala_espera=$request->input('porcentaje_sala_espera');  
        $salas_inversion->fecha_ini=Carbon::parse($request->input('fecha_ini'))->format('Y-m-d');
        $salas_inversion->fecha_fin=Carbon::parse($request->input('fecha_fin'))->format('Y-m-d');

        $salas_inversion->save();

        $salas_inversion = SalasInversion::paginate(20); 
        return new RedirectResponse(url('/salas_inversion/list'));
    }

    public function Editsalasinversion($id)
    { 
        $salas_inversion = SalasInversion::find($id);
        $promociones = DB::select('SELECT * FROM promociones WHERE promociones.id_sala = ? ORDER BY  id ASC ', [$id]);
        return view('salas_inversion.actualizar',compact(
                'salas_inversion',
                'promociones'
        ));
        
    }

    public function Updatesalasinversion(Request $request)
    { 
        
        $salas_inversion = SalasInversion::find($request->input('id')); 
        $salas_inversion->nombre=$request->input('nombre');        
        $salas_inversion->descripcion=$request->input('descripcion');  
        $salas_inversion->valor=$request->input('valor');  
        $salas_inversion->porcentaje_invitacion_directa=$request->input('porcentaje_invitacion_directa');  
        $salas_inversion->porcentaje_interes_compuesto=$request->input('porcentaje_interes_compuesto');  
        $salas_inversion->porcentaje_sala_espera=$request->input('porcentaje_sala_espera');    
        $salas_inversion->fecha_ini=Carbon::parse($request->input('fecha_ini'))->format('Y-m-d');
        $salas_inversion->fecha_fin=Carbon::parse($request->input('fecha_fin'))->format('Y-m-d');      

        if ( $request->file('attachment_1')){            

                        $filename = sha1($request->file('attachment_1')->getClientOriginalName() . uniqid() . getrandmax()). '.' . $request->file('attachment_1')->getClientOriginalExtension();

                        Storage::put($filename, file_get_contents($request->file('attachment_1')->getRealPath()),'public'); 
                        $size = Storage::size($filename);

                        $salas_inversion->archivo_1 = $filename;  
                    } 


        $salas_inversion->save();
 
        return new RedirectResponse(url('/salas_inversion/list'));


    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        $salas_inversion = SalasInversion::find($id); 
        $salas_inversion->delete();
    }

    public function Deletesalasinversion($id)
    {  
        $salas_inversion = SalasInversion::find($id); 
        $salas_inversion->delete();
 
        return new RedirectResponse(url('/salas_inversion/list'));
         
        
    }


    


    
}
