<?php

namespace App\Http\Controllers;

use App\Models\Users; 
use App\Models\Perfil;
use App\Models\SalasInversion; 
use App\Models\SalasInversionCapitalizacion; 
use App\Models\Promociones; 
use App\Models\Capitalizaciones; 
use App\Models\Transacciones; 

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;
use Carbon\Carbon;
use Illuminate\Support\Facades\Storage;
use DB;

use Illuminate\Http\RedirectResponse;

class UsersController extends Controller
{
    /**
     * Display a listing of the resource.
     */

    public function Listusers()
    {
        $users = DB::table('users')     
        ->leftjoin('perfiles', 'users.current_team_id', '=' ,'perfiles.id')  
        ->get(['users.id AS id_u_user', 
        'perfiles.nombre as socios_nombre', 
        'perfiles.profile_photo_path as socios_profile_photo_url', 
        'users.name as user_name', 
        'users.email as user_email', 
        'users.created_at as created_at', 
        'users.status as status', 
        'users.id', 
        'users.balance', 
        'users.balance_interes', 
        'users.cuenta_validada as cuenta_validada', 
        'users.current_team_id as user_current_team_id' ]);   

              $tipo_user = "Inversionistas";


       // dd($users);
        return view('users.catalogo',compact('users','tipo_user'));
        
    }

    public function Addusers()
    {  
        $perfiles = Perfil::paginate(20);
        
        return view('users.registro',compact('perfiles'));
        
    }

    public function Saveusers(Request $request)
    { 

       // dd($request->input('name'));
    
        $user = new Users();
        $user->name=$request->input('name');        
        $user->email=$request->input('email');                          
        $user->current_team_id=$request->input('current_team_id');                          
        $user->password=Hash::make($request->input('password')); 

        $user->save();

 
        $users = DB::table('users')     
        ->leftjoin('perfiles', 'users.current_team_id', '=' ,'perfiles.id')        
        ->get(['users.id AS id_u_user', 
        'perfiles.nombre as socios_nombre', 
        'perfiles.profile_photo_path as socios_profile_photo_url', 
        'users.name as user_name', 
        'users.email as user_email', 
        'users.current_team_id as user_current_team_id' ]);   
 
        return new RedirectResponse(url('/user'));
    }

    public function Editusers($id)
    { 
        $users = Users::find($id); 
        $perfiles = Perfil::paginate(20);


        $cap_users_totales = DB::select('SELECT SUM(monto) as total_monto, SUM(monto_retorno) as total_monto_retorno
            FROM capitalizaciones 
            WHERE capitalizaciones.id_user = ? and status = 1 ', [$id]);

        $salas_users_totales = DB::select('SELECT SUM(monto) as total_monto, SUM(monto_retorno) as total_monto_retorno
            FROM salas_espera 
            WHERE salas_espera.id_user = ? and status = 1 ', [$id]);

        $cap_users_totales_activo = DB::select('SELECT SUM(monto) as total_monto, SUM(monto_retorno) as total_monto_retorno
            FROM capitalizaciones 
            WHERE capitalizaciones.id_user = ? and status = 0 ', [$id]);

        $salas_users_totales_activo = DB::select('SELECT SUM(monto) as total_monto, SUM(monto_retorno) as total_monto_retorno
            FROM salas_espera 
            WHERE salas_espera.id_user = ? and status = 0 ', [$id]);


        $transacciones =  DB::table('transacciones')       
        ->join('users', 'transacciones.id_user', '=' ,'users.id')  
        ->leftJoin('bancos', 'users.id_banco', '=' ,'bancos.id')   
        ->leftJoin('salas_inversion', 'transacciones.id_sala', '=' ,'salas_inversion.id')  
        ->leftJoin('salas_inversion_capitalizacion', 'transacciones.id_sala_capitalizacion', '=' ,'salas_inversion_capitalizacion.id')  
        ->where('transacciones.id_user', '=', $id) 
        ->get([
        'transacciones.*',        
        'bancos.nombre as banco_nombre', 
        'bancos.clave as banco_clave' ]); 

        $hoy = Carbon::now('America/Mexico_City')->toDateString();
        $membresia = 0;   

    
        $id_user = $users->id;   
        $interes_compuesto = $users->interes_compuesto;

        if($users->membresia>=$hoy)
            $membresia = 1;      


        $salas_inversion = DB::table('salas_inversion_capitalizacion')   
                    ->where('salas_inversion_capitalizacion.prioridad', '=', 1) 
                    ->orderBy('salas_inversion_capitalizacion.valor', 'asc') 
                    ->get([ 
                        'salas_inversion_capitalizacion.*'

                    ]);
 

        return view('users.actualizar',compact('users','perfiles','cap_users_totales','salas_users_totales','cap_users_totales_activo','salas_users_totales_activo','transacciones','salas_inversion','membresia','interes_compuesto'));
        
    }

    public function Updateuser(Request $request)
    { 
        
        $user = Users::find($request->input('id')); 
        $user->name=$request->input('name');        
        $user->email=$request->input('email');                          
        $user->current_team_id=$request->input('current_team_id');        
         if ( $request->input('password')){
                     $user->password=Hash::make($request->input('password'));  
         }
   
        $user->save();



        $users = DB::table('users')     
        ->leftjoin('perfiles', 'users.current_team_id', '=' ,'perfiles.id')        
        ->get(['users.id AS id_u_user', 
        'perfiles.nombre as socios_nombre', 
        'perfiles.profile_photo_path as socios_profile_photo_url', 
        'users.name as user_name', 
        'users.email as user_email', 
        'users.current_team_id as user_current_team_id' ]);   

       // dd($users);  
        return new RedirectResponse(url('/user'));
    
}

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
       public function destroy(string $id)
    {
        $user = Users::find($id); 
        $user->delete();
        $users = Users::paginate(20);
        return view('user.catalogo',compact('user'));
    }

     public function Destroyuser(string $id)
    {
        $user = Users::find($id); 
        $user->delete();
        return back();
    }


        public function ListCuentasValidar()
    {
        $users = DB::table('users')     
        ->leftjoin('perfiles', 'users.current_team_id', '=' ,'perfiles.id')  
        ->join('bancos', 'users.id_banco', '=' ,'bancos.id')  
        ->where('users.cuenta_validada', '=', 1)  
        ->get(['users.id AS id_u_user', 
        'perfiles.nombre as socios_nombre', 
        'perfiles.profile_photo_path as socios_profile_photo_url', 
        'users.name as user_name', 
        'users.email as user_email', 
        'users.created_at as created_at', 
        'users.status as status', 
        'users.cuenta_validada as cuenta_validada', 
        'users.clabe_banco as clabe_banco', 
        'users.nombre_banco as nombre_banco', 
        'bancos.nombre as banco_nombre', 
        'users.current_team_id as user_current_team_id' ]);   

              $tipo_user = "Inversionistas";


       // dd($users);
        return view('users.cuentas_por_validar',compact('users','tipo_user'));
        
    }

            public function ListCuentasActivas()
    {
        $users = DB::table('users')     
        ->leftjoin('perfiles', 'users.current_team_id', '=' ,'perfiles.id')  
        ->join('bancos', 'users.id_banco', '=' ,'bancos.id')  
        ->where('users.cuenta_validada', '=', 3)  
        ->get(['users.id AS id_u_user', 
        'perfiles.nombre as socios_nombre', 
        'perfiles.profile_photo_path as socios_profile_photo_url', 
        'users.name as user_name', 
        'users.email as user_email', 
        'users.created_at as created_at', 
        'users.status as status', 
        'users.cuenta_validada as cuenta_validada', 
        'users.clabe_banco as clabe_banco', 
        'users.nombre_banco as nombre_banco', 
        'bancos.nombre as banco_nombre', 
        'users.current_team_id as user_current_team_id' ]);   

              $tipo_user = "Inversionistas";


       // dd($users);
        return view('users.cuentas_activas',compact('users','tipo_user'));
        
    }

    public function ListCuentasRechazadas()
    {
        $users = DB::table('users')     
        ->leftjoin('perfiles', 'users.current_team_id', '=' ,'perfiles.id')  
        ->join('bancos', 'users.id_banco', '=' ,'bancos.id')  
        ->where('users.cuenta_validada', '=', 2)  
        ->get(['users.id AS id_u_user', 
        'perfiles.nombre as socios_nombre', 
        'perfiles.profile_photo_path as socios_profile_photo_url', 
        'users.name as user_name', 
        'users.email as user_email', 
        'users.created_at as created_at', 
        'users.status as status', 
        'users.cuenta_validada as cuenta_validada', 
        'users.clabe_banco as clabe_banco', 
        'users.nombre_banco as nombre_banco', 
        'bancos.nombre as banco_nombre', 
        'users.current_team_id as user_current_team_id' ]);   

              $tipo_user = "Inversionistas";


       // dd($users);
        return view('users.cuentas_rechazadas',compact('users','tipo_user'));
        
    }

     public function ListSinCuenta()
    {
        $users = DB::table('users')     
        ->leftjoin('perfiles', 'users.current_team_id', '=' ,'perfiles.id')  
        ->join('bancos', 'users.id_banco', '=' ,'bancos.id')  
        ->where('users.cuenta_validada', '=', 0)  
        ->get(['users.id AS id_u_user', 
        'perfiles.nombre as socios_nombre', 
        'perfiles.profile_photo_path as socios_profile_photo_url', 
        'users.name as user_name', 
        'users.email as user_email', 
        'users.created_at as created_at', 
        'users.status as status', 
        'users.cuenta_validada as cuenta_validada', 
        'users.clabe_banco as clabe_banco', 
        'users.nombre_banco as nombre_banco', 
        'bancos.nombre as banco_nombre', 
        'users.current_team_id as user_current_team_id' ]);    

              $tipo_user = "Inversionistas";


       // dd($users);
        return view('users.usuarios_sin_cuenta',compact('users','tipo_user'));
        
    }


            public function Crearinversion(Request $request){
 
            $users = Users::find($request->input('id')); 
            $id_user = $users->id; 


            $salas_inversion = SalasInversionCapitalizacion::find($request->input('id_sala'));

  
            $capitalizaciones = new Capitalizaciones();
            $capitalizaciones->id_sala=$request->input('id_sala');
            $capitalizaciones->id_user=$id_user;
            $capitalizaciones->monto=$salas_inversion->valor;
            $capitalizaciones->porcentaje=$salas_inversion->porcentaje_invitacion_directa;
            $capitalizaciones->monto_retorno=$salas_inversion->valor*1*($salas_inversion->porcentaje_invitacion_directa/100+1); 
            if ($request->has('interes_compuesto')&&($users->interes_compuesto==0)) {
                $capitalizaciones->interes_compuesto=1; 
                $capitalizaciones->porcentaje=$salas_inversion->porcentaje_interes_compuesto;
                $capitalizaciones->monto_retorno=$salas_inversion->valor*1*($salas_inversion->porcentaje_interes_compuesto/100+1); 
            }



          $capitalizaciones->status=0;
        $capitalizaciones->created_at=Carbon::now('America/Mexico_City');
        $capitalizaciones->save();
            $membresia = 0;

        $total = $capitalizaciones->monto;

        if ($request->input('membresia_pago')==1) {
            $users->membresia=Carbon::now('America/Mexico_City')->addYear(); 
            $membresia = 50;
            $total += 50;
        }

        if (($request->input('interes_compuesto')==1)&&($users->interes_compuesto==0)) {
            $users->interes_compuesto=1; 
        }


            $users->save();


             /***********************************/

            $transacciones = new Transacciones();
            $transacciones->id_user=$id_user;   
            $transacciones->monto=$capitalizaciones->monto;
            $transacciones->membresia=$membresia;        
            $transacciones->pago=$total;     
            $transacciones->descripcion="Invitación Directa";   
            $transacciones->status=6;   //Invitación Directa
            $transacciones->tipo_pago=1;   
            $transacciones->id_sala_capitalizacion=$request->input('id_sala');  
            $transacciones->created_at=Carbon::now('America/Mexico_City');
            $transacciones->save();


            /************************************/

        //return back(); 
        //return new RedirectResponse(url('/paypal/edit/1/'.$request->input('id_sala')));
 
        return new RedirectResponse(url('/user'));

       
    }
}
