@extends('admin.admin_dashboard')
@section('content')
				
<div class="pc-container">
    <div class="pc-content">
      <!-- [ breadcrumb ] start -->
      <div class="page-header">
        <div class="page-block">
          <div class="row align-items-center">
            <div class="col-md-12">
              <ul class="breadcrumb mb-3">
                <li class="breadcrumb-item"><a href="../home">Home</a></li>
                <li class="breadcrumb-item"><a href="../disciplinas">Sala Inversión</a></li>
                <li class="breadcrumb-item" aria-current="page">Actualizar Sala Inversión</li>
              </ul>
            </div>
            <div class="col-md-12">
              <div class="page-header-title">
                <h2 class="mb-0">Actualizar Sala Inversión</h2>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- [ breadcrumb ] end -->

              
      <!-- [ Main Content ] start -->
      <div class="row">
        <!-- [ sample-page ] start -->
        <div class="col-sm-12">
          <div class="card">
            <div class="card-body"> 
                          <h3 class="mb-3" style="color: blue">Información General</h3>
               <form class="smart-form" enctype="multipart/form-data" method="POST" action="{{ route('sala_inversion/update')}}">
               	
              <div class="row"> 
                 
                @csrf

                <input type="hidden" name="id" value="{{$salas_inversion->id}}">
                <div class="col-md-4"> 
                  <div class="form-group">
                    <label class="form-label">% Porcentaje Invitación Directa</label>
                    <input id="porcentaje_invitacion_directa" name="porcentaje_invitacion_directa" type="text" class="form-control" placeholder="$" value="{{number_format($salas_inversion->porcentaje_invitacion_directa , 0, '.', '')}}">
                  </div>

                  <div class="form-group">
                    <label class="form-label">% Porcentaje Interés Compuesto</label>
                    <input id="porcentaje_interes_compuesto" name="porcentaje_interes_compuesto" type="text" class="form-control" placeholder="$" value="{{number_format($salas_inversion->porcentaje_interes_compuesto , 0, '.', '')}}">
                  </div>


                  <div class="form-group">
                    <label class="form-label">% Porcentaje Sala de Espera</label>
                    <input id="porcentaje_sala_espera" name="porcentaje_sala_espera" type="text" class="form-control" placeholder="$" value="{{number_format($salas_inversion->porcentaje_sala_espera , 0, '.', '')}}">
                  </div>

                  

                </div>

                <div class="col-md-4">
                  <div class="form-group">
                    <label class="form-label">No. Sala</label>
                    <input id="nombre" name="nombre" type="text" class="form-control" placeholder="Nombre" value="{{$salas_inversion->nombre}}">
                  </div>

                  <div class="form-group">
                    <label class="form-label">Descripción</label>
                    <input id="descripcion" name="descripcion" type="text" class="form-control" placeholder="Descripción" value="{{$salas_inversion->descripcion}}">
                  </div>

                  <div class="form-group">
                    <label class="form-label">Valor $ MXN</label>
                    <input id="valor" name="valor" type="text" class="form-control" placeholder="$" value="{{number_format($salas_inversion->valor , 0, '.', '')}}">
                  </div>

                  
                </div>


                 <div class="col-md-4">

                  <div class="form-group">
                    <label class="form-label">Subir / Actualizar imágen</label> 
                     <div class="input-group">
                        <input type="file" id="attachment_1" name="attachment_1" class="form-control" />
                      </div>
                  </div>



                  <div class="form-group" style="width: 200px !important"> 
                            <img src="{{ config('services.url_global.key') }}/storage/app/{{$salas_inversion->archivo_1}}" alt=""  width="100px"  height="100px" class="card-img" /> 

                  </div>

                  <div class="form-group">
                     <div class="text-left btn-page mb-0 mt-4">
                    <a href="../../salas_inversion/list" class="btn btn-outline-secondary">Regresar</a> 
                    <button type="submit" class="btn btn-primary">Guardar Sala Inversión</button>
                  </div>
                  </div>
                  
                </div>


                 

              </div>
              </form> 


            </div>
          </div>
        </div>
        <!-- [ sample-page ] end -->
      </div>      <!-- [ Main Content ] end -->

                <div  class="col-xl-12">
                  <div class="card">
                    <div class="card-header">  
                          <h3 class="mb-3" style="color: blue">Agregar promociones</h3>

            <!-- [ varying-modal ] start -->  
 
  
  
                <form  role="form" method="POST" enctype="multipart/form-data" action="{{ route('promocion/store_file_promocion_detalle')}}"   >              
                        @csrf
                        <input type="hidden" name="id_sala" value="{{$salas_inversion->id}}">
                      
                    <div class="row">  

                      <div class="col-md-4"> 
                         <div class="form-group">
                          <label class="form-label">Título</label>
                          <input id="descripcion" name="descripcion" type="text" class="form-control" placeholder="Descripción" value="{{ (old('descripcion')) ?  old('descripcion') : ''}}">
                  @error('descripcion') <span class="fs-6 text-danger">{{$message}}</span>  @enderror    
                        </div>
                         <div class="form-group">
                          <label class="form-label">Descripción</label>
 
                        <textarea class="form-control" id="comentarios" name="comentarios" rows="8">{{ (old('comentarios')) ?  old('comentarios') : ''}}</textarea>
                     
                  @error('comentarios') <span class="fs-6 text-danger">{{$message}}</span>  @enderror    
                            
                    </div>
                    
                        <div class="form-group">
                    <button type="submit" class="btn btn-primary">Agregar Promoción</button>
                        </div>
                           
                  </div>
                      <div class="col-md-4">  
                        <div class="form-group">
                          <label class="form-label">Porcentaje</label>
                          <input id="porcentaje" name="porcentaje" type="text" class="form-control" placeholder="Porcentaje" value="{{ (old('precio_unitario')) ?  old('porcentaje') : ''}}" onkeydown="actualiza_importe();">
                  @error('porcentaje') <span class="fs-6 text-danger">{{$message}}</span>  @enderror    
                        </div> 
                    <div class="form-group">
                    <label class="form-label">Fecha de Inicio</label> 
                      <input type="text" class="form-control fecha_ini" id="fecha_ini" name="fecha_ini" placeholder="Seleccione fecha" > 
                  </div> 
                  <div class="form-group">
                    <label class="form-label">Fecha de Finalización</label> 
                      <input type="text" class="form-control fecha_fin" id="fecha_fin" name="fecha_fin" placeholder="Seleccione fecha"> 
                  </div> 
                  </div>
                  <div class="col-md-4">
                      

                        <div class="form-group">
                          <label class="form-label">Subir imágen</label>
                          <div class="form-group">
                                  <div class="input-group">
                                    <input type="file" id="attachment_1" name="attachment_1" class="form-control" />
                                  </div>
                              </div>  
                        </div>

                  </div>  
 
                     


                  </div>  

                  
                </div>
                  
            </form>
  

                    
                    </div>
                  </div>

            <!-- [ varying-modal ] start -->

            </div> 
      <!-- [ Main Content ] end -->

<div class="row"> 
  <div class="table-responsive dt-responsive">
                  <table id="table-inventory-cat" class="table table-striped table-bordered">
                    <thead>
                      <tr>    
                        <th>Título</th> 
                        <th style="width: 400px !important">Descripción</th>     
                        <th>Fecha inicio</th>
                        <th>Fecha fin</th>
                        <th>Imágen</th>
                        <th>Porcentaje</th>
                        <th>Editar / Eliminar</th>
                      </tr>
                    </thead>
                    <tbody>
                    @foreach($promociones as $promociones)                   
                      
                      <tr>  
                      <td>{{ $promociones->descripcion}}</td>   
                      <td style="width: 400px !important">{{ $promociones->comentarios}}</td>     
                      <td>{{ $promociones->fecha_ini}}</td>   
                      <td>{{ $promociones->fecha_fin}}</td>   
                        <td style="width: 200px !important"> 
                                   
                            <img src="{{ config('services.url_global.key') }}/storage/app/{{$promociones->archivo_1}}" alt=""  width="100px"  height="100px" class="card-img" /> 
                           
                             
                        </td>
                      <td>{{ number_format($promociones->porcentaje, 0, '.', ',')}}% </td>  
                        <td>  
                           <ul class="list-inline me-auto mb-0"> 
                          <li class="list-inline-item align-bottom" data-bs-toggle="tooltip" title="Edit">
                             <div class="modal fade" id="exampleModal_{{ $promociones->id}}" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel_{{ $promociones->id}}" aria-hidden="true">
                    <div class="modal-dialog" role="document">
                      <div class="modal-content">
                        <div class="modal-header">
                          <h5 class="modal-title" id="exampleModalLabel_{{ $promociones->id}}">Modificar</h5>
                          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                        </div>
                
 
                  <form class="smart-form" method="POST"  enctype="multipart/form-data" action="{{ route('promocion/update')}}">
                    @csrf
                    <input type="hidden" name="id" value="{{$promociones->id}}">

                    <div class="modal-body"> 
                        <div class="form-group">
                          <label class="form-label">Título</label>
                          <input id="descripcion" name="descripcion" type="text" class="form-control" placeholder="Unidad de medida" value="{{ $promociones->descripcion}}">
                        </div>

                        <div class="form-group">
                          <label class="form-label">Descripción</label>

                        <textarea class="form-control" id="comentarios" name="comentarios" rows="4">{{ $promociones->comentarios}}</textarea>
                        </div>  
                          
                        <div class="form-group">
                          <label class="form-label">Porcentaje</label>
                          <input id="porcentaje" name="porcentaje" type="text" class="form-control" placeholder="Porcentaje" value="{{$promociones->porcentaje}}" >
                        </div>
 

                        <div class="form-group">
                          <label class="form-label">Fecha de Inicio</label> 
                            <input type="text" class="form-control fecha_ini" id="fecha_ini" name="fecha_ini" placeholder="Seleccione fecha" value=" {{ date('m/d/Y',strtotime($promociones->fecha_ini))}}"  > 
                        </div> 
                        <div class="form-group">
                          <label class="form-label">Fecha de Finalización</label> 
                            <input type="text" class="form-control fecha_fin" id="fecha_fin" name="fecha_fin" placeholder="Seleccione fecha" value=" {{ date('m/d/Y',strtotime($promociones->fecha_fin))}}" > 
                        </div> 

                        <div class="form-group">
                          <div class="form-group">
                                  <div class="input-group">
                                    <input type="file" id="attachment_1" name="attachment_1" class="form-control" />
                                  </div>
                              </div>
                            
                        </div>


                    </div>


                    <div class="modal-footer">
                      <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
                      <button type="submit" class="btn btn-primary">Guardar</button>
                    </div>
                    </form>

                      </div>
                    </div>
                  </div>


 
                            <button type="button" class="avtar avtar-xs btn-link-success btn-pc-default" data-bs-toggle="modal" data-bs-target="#exampleModal_{{ $promociones->id}}" data-bs-whatever="@getbootstrap" style="margin-left: 20px;"><i class="ti ti-edit f-18"></i></button>


                          </li>
                          <li class="list-inline-item align-bottom" data-bs-toggle="tooltip" title=""> 


                        <form class="smart-form" method="POST" action="{{ route('promocion/delete_promocion')}}">

                            @csrf 

                            <input type="hidden" name="id" value="{{$promociones->id}}">
                            <button type="submit" class="avtar avtar-s btn-link-danger btn-pc-default flex-shrink-0">
                              <i class="ti ti-trash f-20"></i>
                            </button>  

                        </form>

                          </li>
                      </td> 
                      </tr>
                    @endforeach

                    </tbody> 
                  </table>
                </div>

</div>




    </div>
  </div>

          <!-- DOM/Jquery table end -->
<!--main--> 

    <!-- datatable Js --> 
 
<script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
<script src="{{ URL::asset('js/plugins/jquery.dataTables.min.js')}}"></script>
<script src="{{ URL::asset('js/plugins/dataTables.bootstrap5.min.js')}}"></script>
<script src="{{ URL::asset('js/plugins/dataTables.responsive.min.js')}}"></script>
<script src="{{ URL::asset('js/plugins/responsive.bootstrap5.min.js')}}"></script>
<script src="{{ URL::asset('js/plugins/datepicker-full.min.js')}}"></script>
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.10.2/jquery.min.js"></script>  
<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/sweetalert/1.1.3/sweetalert.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.8.0/js/bootstrap-datepicker.min.js"></script>

    <script>

            $(".fecha_ini").datepicker( {   
    todayBtn: "linked", 
            keyboardNavigation: false,
            forceParse: false, 
            autoclose: true
});                  // minimum setup

     $(".fecha_fin").datepicker( {   
    todayBtn: "linked", 
            keyboardNavigation: false,
            forceParse: false, 
            autoclose: true
}); 
      // [ DOM/jquery ] 
 $(document).ready(function()
            {
   
                
    }); // FIN DE TABLA
 </script>

@endsection